function [model, g0] = om_coupling(model, entities, ...
    optSol, mechSol)

%% set constants (SI)

epsSi=11.7;
p11=-0.094;
p12=0.017;
p44=-0.051;
hbar = 1.054571628e-34;
eps0 = 8.854187817e-12;
nSi = sqrt(epsSi);

%% general mechanics parameters (maximum displacement, Omega, effective mass, ...)

[Eval.Qmax,Eval.unitQmax] = mphmax(model,...
    ['sqrt(real(u)^2+real(v)^2+real(w)^2+imag(u)^2+imag(v)^2'...
     '+imag(w)^2)'],'volume','solnum',mechSol,'dataset','dset2');

switch Eval.unitQmax{1}
    case 'm'
        Eval.QmaxOrig = Eval.Qmax;
    case 'nm'
        Eval.QmaxOrig = Eval.Qmax;
        Eval.Qmax = Eval.Qmax*1e-9;
        Eval.unitQmaxOrig = Eval.unitQmax;
        Eval.unitQmax = {'m'};
    otherwise
        disp('Check unit of Qmax.')
end

Eval.omegaM = real(mphglobal(model,'freq','solnum',mechSol,...
    'dataset','dset2'));
Eval.omegaM = transpose(Eval.omegaM);

si_domain = model.physics('solid').selection().inputEntities;
[Eval.massInt, Eval.unitmassInt] = mphint2(model,...
    'solid.rho*2*(solid.disp_rms)^2','volume','selection',...
    si_domain,'solnum',mechSol,'dataset','dset2');

switch Eval.unitmassInt{1}
    case 'm^2*kg' 
        Eval.meff = Eval.massInt./Eval.Qmax.^2;
    case 'kg*m^2'
        Eval.meff = Eval.massInt./Eval.Qmax.^2;
    otherwise
        disp('Check unit of the effective mass integration.')
end

Eval.xzpf = sqrt(hbar./(2.*Eval.meff.*Eval.omegaM.*2*pi));

%% general optical parameters

opt_volume = model.physics('emw').selection().inputEntities;
[Eval.Eint, Eval.unitEint] = mphint2(model,[...
    sprintf('%.9e',eps0) '*emw.epsrAv*emw.normE^2'],...
    'volume','selection',opt_volume,'solnum',optSol.number,'dataset','dset1');

switch Eval.unitEint{1} % together with As/Vm this gives Joule
    case 'm^5*kg^2/(s^6*A^2)'
    case 'kg^2*m^5/(s^6*A^2)'
    otherwise
        disp('Check unit of the E-field integration.')
end

%% moving dielectric boundary

% disp('Calculating contribution from moving dielectric boundary...')
[Eval.surfaceInt, Eval.surfaceIntUnit] = mphint2(model, ...
    ['((real(u)+i*imag(u))*nx+(real(v)+i*imag(v))*ny+(real(w)+i*imag(w))*nz)*' ...
    '(' sprintf('%.9e',eps0) '*(' sprintf('%.9e',epsSi) '-1)*' ...
    '(abs(emw.Ex*t1x+emw.Ey*t1y+emw.Ez*t1z)^2' ...
    '+abs(emw.Ex*t2x+emw.Ey*t2y+emw.Ez*t2z)^2)' ...
    '-(1/' sprintf('%.9e',epsSi) '-1)/' sprintf('%.9e',eps0) ...
    '*(abs(emw.Dx*nx+emw.Dy*ny+emw.Dz*nz)^2))'], ...
    'surface','selection',entities.acbeamSurf,'solnum',mechSol,'dataset','dset2');

Eval.domegadalphaMB = -optSol.freq * Eval.surfaceInt ./ (2*Eval.Eint*Eval.Qmax);
Eval.gMB = Eval.domegadalphaMB .* Eval.xzpf;

%% stress-optical effect

% disp('Calculating contribution from stress-optical effect...')
[Eval.volumeInt, Eval.volumeIntUnit] = mphint2(model, ...
    ['2*real(conj(emw.Ex)*emw.Ey)*' num2str(p44) '*(real(solid.eXY)+i*imag(solid.eXY))' ...
    '+2*real(conj(emw.Ex)*emw.Ez)*' num2str(p44) '*(real(solid.eXZ)+i*imag(solid.eXZ))' ...
    '+2*real(conj(emw.Ey)*emw.Ez)*' num2str(p44) '*(real(solid.eYZ)+i*imag(solid.eYZ))' ...
    '+(abs(emw.Ex)^2)*(' num2str(p11) '*(real(solid.eXX)+i*imag(solid.eXX))+' num2str(p12) '*((real(solid.eYY)+i*imag(solid.eYY))+(real(solid.eZZ)+i*imag(solid.eZZ))))' ...
    '+(abs(emw.Ey)^2)*(' num2str(p11) '*(real(solid.eYY)+i*imag(solid.eYY))+' num2str(p12) '*((real(solid.eXX)+i*imag(solid.eXX))+(real(solid.eZZ)+i*imag(solid.eZZ))))' ...
    '+(abs(emw.Ez)^2)*(' num2str(p11) '*(real(solid.eZZ)+i*imag(solid.eZZ))+' num2str(p12) '*((real(solid.eXX)+i*imag(solid.eXX))+(real(solid.eYY)+i*imag(solid.eYY))))'], ...
    'volume','selection',entities.acbeamVol,'solnum',mechSol,'dataset','dset2');

switch Eval.volumeIntUnit{1}
    case 'm^5*kg^2/(s^6*A^2)'
    case 'kg^2*m^5/(s^6*A^2)'
    otherwise
        disp('Check unit of volume stress Integration.')
end

Eval.domegadalphaPE = optSol.freq*eps0*nSi^4*Eval.volumeInt./(2*Eval.Eint*Eval.Qmax);
Eval.gPE = Eval.domegadalphaPE .* Eval.xzpf;

% ************Please note the final expression of g0*************
g0 = abs(Eval.gMB+Eval.gPE);

end